/**
 * Klasse WordGrid
 * Bild in dem versteckte Elemente gefunden werden sollen
 *
 * @constructor
 * @param {float} pPosX Position.x des Bildes
 * @param {float} pPosY Position.y des Bildes
 * @param {float} pWidth Breite des Bildes
 * @param {float} pHeight Höhe des Bildes
 * @param {string} pImgSrc Pfad des Bildes
 */
function WordGrid(pPosX, pPosY, pWidth, pHeight, pImgSrc) {
    this.pType = "WordGrid";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pImgSrc = pImgSrc;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.rWords = [];

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<div class="wordGrid"></div>').appendTo(this.rPatent);
        makeUnselectable(this.rSelector);
        this.rImg = $('<img src="' + this.pImgSrc + '" class="wordGridImg">').appendTo(this.rSelector);
        this.rImg.css("z-index", 1);
        makeUnselectable(this.rImg);

        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        var t = this;

        $(this.rSelector).click(function (e) {
            t.click();
        });

        // individual solve button
        var btns = boards[this.pBoardId].addSolvabel(this);
        this.rSolve = btns.solve;
        this.rReset = btns.reset;
    };

    /**
     * Setzt das Icon fuer den Solve-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setSolveIcon = function (pIcon) {
        this.rSolve.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt das Icon fuer den Reset-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setResetIcon = function (pIcon) {
        this.rReset.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Fuegt dem Gitter ein neues Loesungswort hinzu
     * @param {float} pPosX Position.x des Wortes
     * @param {float} pPosY Position.y des Wortes
     * @param {float} pWidth Breite des Wortes
     * @param {float} pHeight Höhe des Wortes
     */
    this.addWord = function (pPosX, pPosY, pWidth, pHeight) {
        var word = $('<div class="wordGridWord"></div>').appendTo(this.rSelector);
        word.css("z-index", 2);

        word.css("width", pWidth + "px");
        word.css("height", pHeight + "px");
        word.css("left", pPosX + "px");
        word.css("top", pPosY + "px");

        word.attr("pInitialWidth", pWidth);
        word.attr("pInitialHeight", pHeight);
        word.attr("pInitialLeft", pPosX);
        word.attr("pInitialTop", pPosY);

        word.click(function (e) {
            if (word.css("background-color") == "rgba(0, 0, 0, 0)") {
                word.css("background-color", "rgba(255, 0, 0, 0.5)");
                word.css("border", "3px solid red");
            } else {
                word.css("background-color", "rgba(0, 0, 0, 0)");
                word.css("border", "none");
            }
        });
        this.rWords.push(word);
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        this.rSelector.find(".wordGridWord").each(function (i) {
            $(this).css("width", parseFloat($(this).attr("pInitialWidth")) * pScale + "px");
            $(this).css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");
        });
    };

    /**
     * Funktion wenn das Gitter angeklickt wird
     */
    this.click = function () {
        //this.pSolved = !this.pSolved;
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {
        this.rSelector.find(".wordGridWord").each(function (i) {
            $(this).css("background-color", "rgba(255, 0, 0, 0.5)");
            $(this).css("border", "3px solid red");
        });
    };

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        this.rSelector.find(".wordGridWord").each(function (i) {
            $(this).css("background-color", "rgba(0, 0, 0, 0)");
            $(this).css("border", "none");
        });
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType) {
            if (this.isSolved() != rObj.pSolved) {
                this.click();
            }
        }
    };
}
