/**
 * Textbox in dem Text eingetippt werden kann
 *
 * @constructor
 * @param {float} pPosX Position.x der Textbox
 * @param {float} pPosY Position.y der Textbox
 * @param {float} pWidth Breite der Textbox
 * @param {float} pHeight Höhe der Textbox
 * @param {float} pFontSize Schriftgröße des Textes
 */
function TextBox(pPosX, pPosY, pWidth, pHeight, pFontSize) {
    this.pType = "TextBox";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pText = "";
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.pFontSize = pFontSize;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<div class="textBox shadow">' + this.pText + "</div>").appendTo(this.rPatent);
        this.rTextArea = $("<textarea>" + this.pText + "</textarea>").appendTo(this.rSelector);
        //makeUnselectable(this.rSelector);

        this.rSelector.attr("spellcheck", false);

        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        var t = this;

        $(this.rTextArea).on("change keyup paste", function () {
            t.pText = $(t.rTextArea).val();
        });
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        if (this.pFontSize) $(this.rTextArea).css("font-size", this.pFontSize * pScale);
    };

    /**
     * Funktion wenn das Gitter angeklickt wird
     */
    // this.click = function () {
    //     $(this.rCovers[this.pIndex]).hide();
    //     this.pIndex = Math.min(this.pIndex + 1, this.rCovers.length - 1);
    // };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {};

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        $(this.rTextArea).val("");
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pText: this.pText,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && this.pJsonId == rObj.pJsonId) {
            this.pText = rObj.pText;
            $(this.rTextArea).val(rObj.pText);
        }
    };
}
