/**
 * SlideShow Klasse
 * Zeigt Bilder nacheinander an. Entweder einzeln oder Übereinander
 *
 * @constructor
 * @param {float} pPosX Position.x der Bildfläche
 * @param {float} pPosY Position.y der Bildfläche
 * @param {float} pWidth Breite der Bildfläche
 * @param {float} pHeight Höhe der Bildfläche
 * @param {boolean} pStartEmpty Legt fest ob die Bildfläche leer starten soll
 */
function SlideShow(pPosX, pPosY, pWidth, pHeight, pStartEmpty) {
    this.pType = "SlideShow";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pStartEmpty = pStartEmpty;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.rImgs = [];
    this.pIndex = 0;
    this.pSteps = [0];
    this.pHides = [];
    this.pShows = [];

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        var t = this;
        this.rParent = rParent;
        this.rSelector = $('<div class="slideShow"></div>').appendTo(this.rParent);
        makeUnselectable(this.rSelector);
        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        // left right buttons
        this.rBtnLeft = $('<button class="slideShowBtnLeft"></button>').appendTo(this.rSelector);
        $(this.rBtnLeft).click(function (e) {
            t.click(-1);
        });
        this.rBtnRight = $('<button class="slideShowBtnRight"></button>').appendTo(this.rSelector);
        $(this.rBtnRight).click(function (e) {
            t.click(1);
        });

        // // individual solve button
        // var btns = boards[this.pBoardId].addSolvabel(this);
        // this.rSolve = btns.solve;
        // this.rReset = btns.reset;

        if (this.pStartEmpty) {
            // this.addImage(0, 0, this.pWidth, this.pHeight, "//:0", true);
            this.addStep(0);
        }
    };

    /**
     * Setzt das Icon fuer den Solve-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setSolveIcon = function (pIcon) {
        this.rSolve.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt das Icon fuer den Reset-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setResetIcon = function (pIcon) {
        this.rReset.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Fuegt der SlideShow ein neues Bild hinzu
     * @param {float} pPosX Position.x des Bildes in der Bildfläche
     * @param {float} pPosY Position.y des Bildes in der Bildfläche
     * @param {float} pWidth Breite des Bildes
     * @param {float} pHeight Höhe des Bildes
     * @param {string} pImgSrc Pfad des Bildes
     * @returns {jqueryelement} Das hinzugefuegte Bild
     */
    this.addImage = function (pPosX, pPosY, pWidth, pHeight, pImgSrc) {
        var newImg = $('<img src="' + pImgSrc + '" class="slideShowImg">').appendTo(this.rSelector);
        newImg.css("z-index", 2);

        newImg.css("width", pWidth + "px");
        newImg.css("height", pHeight + "px");
        newImg.css("left", pPosX + "px");
        newImg.css("top", pPosY + "px");

        newImg.attr("pInitialWidth", pWidth);
        newImg.attr("pInitialHeight", pHeight);
        newImg.attr("pInitialLeft", pPosX);
        newImg.attr("pInitialTop", pPosY);
        // newImg.attr("pID", this.rImgs.length);

        this.rImgs.push(newImg);
        this.click(0);

        return newImg;
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        this.rSelector.find(".slideShowImg").each(function (i) {
            $(this).css("width", parseFloat($(this).attr("pInitialWidth")) * pScale + "px");
            $(this).css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");
        });

        // buttons

        if (this.pBtns) {
            $(this.rBtnLeft).css("width", $(this.rBtnLeft).attr("pInitialWidth") * pScale);
            $(this.rBtnLeft).css("height", $(this.rBtnLeft).attr("pInitialHeight") * pScale);
            $(this.rBtnLeft).css("left", $(this.rBtnLeft).attr("pInitialLeft") * pScale);
            $(this.rBtnLeft).css("top", $(this.rBtnLeft).attr("pInitialTop") * pScale);
            $(this.rBtnLeft).css("font-size", $(this.rBtnLeft).attr("pInitialHeight") * pScale);

            $(this.rBtnRight).css("width", $(this.rBtnRight).attr("pInitialWidth") * pScale);
            $(this.rBtnRight).css("height", $(this.rBtnRight).attr("pInitialHeight") * pScale);
            $(this.rBtnRight).css("left", $(this.rBtnRight).attr("pInitialLeft") * pScale);
            $(this.rBtnRight).css("top", $(this.rBtnRight).attr("pInitialTop") * pScale);
            $(this.rBtnRight).css("font-size", $(this.rBtnRight).attr("pInitialHeight") * pScale);
        }
    };

    /**
     * In der Slideshow vor oder zurueck gehen
     * @param {int} pDirection - positive Zahl fuer vorwaerts, negative Zahl fuer rueckwaerts
     */
    this.click = function (pDirection) {
        this.pIndex = Math.max(Math.min(this.pIndex + pDirection, this.pSteps.length - 1), this.pStartEmpty ? 0 : 1);
        // console.log(this.pSteps);
        for (let i = 0; i < this.rImgs.length; i++) {
            this.rImgs[i].hide();
        }
        for (let i = 0; i < this.pIndex + 1; i++) {
            var step = this.pSteps[i];
            for (let h = 0; h < this.pHides.length; h++) {
                var hide = this.pHides[h];
                if (hide[1] == step) {
                    $(hide[0]).hide();
                    // console.log("HIDE");
                }
            }
            for (let s = 0; s < this.pShows.length; s++) {
                var show = this.pShows[s];
                if (show[1] == step) {
                    $(show[0]).show();
                }
            }
        }
    };

    /**
     * Legt fest an welchem index ein Bild ausgeblendet werden soll
     * @param {jqueryelement} pHandle Bild
     * @param {int} pStep index an dem das Bild ausgeblendet werden soll
     */
    this.hideBild = function (pHandle, pStep) {
        this.pHides.push([pHandle, pStep]);
        this.addStep(pStep);
        this.click(0);
    };

    /**
     * Legt fest an welchem index ein Bild eingeblendet werden soll
     * @param {jqueryelement} pHandle
     * @param {int} pStep index an dem das Bild eingeblendet werden soll
     */
    this.showBild = function (pHandle, pStep) {
        this.pShows.push([pHandle, pStep]);
        this.addStep(pStep);
        this.click(0);
    };

    /**
     * Fügt der Slideshow einen neuen Keyframe hinzu
     * @param {int} pStep Nummer des Keyframe
     */
    this.addStep = function (pStep) {
        // console.log("ADD: " + pStep);
        if (!this.pSteps.includes(pStep)) {
            this.pSteps.push(pStep);
            this.pSteps.sort(function (a, b) {
                return a - b;
            });
        }
    };

    /**
     * Setzt die Hintergrundfarbe der Bildfläche
     * @param {string RGB(r,g,b)} pColor
     */
    this.setBackgroundColor = function (pColor) {
        this.rSelector.css("background-color", pColor);
    };

    /**
     * Setzt die Dicke und Farbe der Umrandung der Bildfläche
     * @param {float} pSize
     * @param {string RGB(r,g,b)} pColor
     */
    this.setBorder = function (pSize, pColor) {
        this.rSelector.css("border", pSize + "px solid " + pColor);
    };

    /**
     * Legt fest ob die Ecken der Bildfläche abgerundet werden soll
     * @param {boolean} pEnable
     */
    this.setRoundCorners = function (pEnable) {
        if (pEnable) {
            this.rSelector.css("border-radius", "5%");
        } else {
            this.rSelector.css("border-radius", "0%");
        }
    };

    /**
     * Erstellt zwei Navigationspfeile für die Steuerung der SlideShow
     * @param {float} pWidth Breite Beider Pfeile
     * @param {float} pHeight Höhe beider Pfeile
     * @param {float} pPosX1 Position.x des linken Pfeils
     * @param {float} pPosY1 Position.y des linken Pfeils
     * @param {float} pPosX2 Position.x des rechten PFeils
     * @param {float} pPosY2 Position.y des rechten Pfreils
     */
    this.setButtons = function (pWidth, pHeight, pPosX1, pPosY1, pPosX2, pPosY2) {
        this.pBtns = true;

        $(this.rBtnLeft).attr("pInitialWidth", pWidth);
        $(this.rBtnLeft).attr("pInitialHeight", pHeight);
        $(this.rBtnLeft).attr("pInitialLeft", pPosX1);
        $(this.rBtnLeft).attr("pInitialTop", pPosY1);
        $(this.rBtnLeft).appendTo(this.rParent);
        $(this.rBtnLeft).text("⭠");
        $(this.rBtnLeft).css("width", pWidth);
        $(this.rBtnLeft).css("height", pHeight);
        $(this.rBtnLeft).css("left", pPosX1);
        $(this.rBtnLeft).css("top", pPosY1);
        $(this.rBtnLeft).css("font-size", pHeight);

        $(this.rBtnRight).attr("pInitialWidth", pWidth);
        $(this.rBtnRight).attr("pInitialHeight", pHeight);
        $(this.rBtnRight).attr("pInitialLeft", pPosX2);
        $(this.rBtnRight).attr("pInitialTop", pPosY2);
        $(this.rBtnRight).appendTo(this.rParent);
        $(this.rBtnRight).text("⭢");
        $(this.rBtnRight).css("width", pWidth);
        $(this.rBtnRight).css("height", pHeight);
        $(this.rBtnRight).css("left", pPosX2);
        $(this.rBtnRight).css("top", pPosY2);
        $(this.rBtnRight).css("font-size", pHeight);
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {};

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        // for (let i = 0; i < this.rCovers.length; i++) {
        //     $(this.rCovers[i]).show();
        // }
        // this.pIndex = 0;
        this.click(-this.pIndex);
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
            pIndex: this.pIndex,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && this.pJsonId == rObj.pJsonId) {
            //this.pIndex = rObj.pIndex;
            //for (let i = 0; i < this.pIndex; i++) {
            //    $(this.rImgs[i]).hide();
            //}
            //this.pIndex = 0;
            this.click(rObj.pIndex - this.pIndex);
            //console.log(rObj.pIndex-this.pIndex);
            //console.log(rObj.pIndex)
        }
    };
}
