/**
 * Klasse BackgroundText
 * Ein statischer Text im Hintergrund
 *
 * @constructor
 * @param pPosX {float} position.x
 * @param pPosY {float} position.y
 * @param pWidth {float} Breite
 * @param pHeight {float} Höhe
 * @param pText {String} Text
 */
function BackgroundText(pPosX, pPosY, pWidth, pHeight, pText) {
    this.pType = "BackgroundText";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    //this.pInitialPosX = this.pPosX;
    //this.pInitialPosY = this.pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    //this.pInitialWidth = pWidth;
    //this.pInitialHeight = pHeight;
    this.pText = pText;
    this.pScale = 1;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<div class="backgroundText">' + pText + "</div>").appendTo(this.rPatent);
        makeUnselectable(this.rSelector);
        this.setScale(this.pScale);
    };

    /**
     * Setzt die SKalierung des Bildes
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        $(this.rSelector).css("width", this.pWidth * this.pScale + "px");
        $(this.rSelector).css("height", this.pHeight * this.pScale + "px");
        $(this.rSelector).css("left", this.pPosX * this.pScale + "px");
        $(this.rSelector).css("top", this.pPosY * this.pScale + "px");
        if (this.pFontSize != null) {
            $(this.rSelector).css("font-size", this.pFontSize * this.pScale + "px");
        }
    };

    /**
     * Stellt die Schriftgröße ein
     * @param {float} pFontSize
     */
    this.setFontSize = function (pFontSize) {
        this.pFontSize = pFontSize;
    };

    /**
     * Exportiert den Zustand in einem JSON-Objekt
     */
    this.export = function () {};

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} rObj
     */
    this.import = function (rObj) {};
}
