/**
 * Klasse BackgroundImage
 * Fügt ein Hintergrundbild honzu
 *
 * @constructor
 * @param pPosX {float} position.x
 * @param pPosY {float} position.y
 * @param pWidth {float} Breite
 * @param pHeight {float} Höhe
 * @param pImgSrc {String} Bild Pfad
 */
function BackgroundImage(pPosX, pPosY, pWidth, pHeight, pImgSrc) {
    this.pType = "BackgroundImage";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    //this.pInitialPosX = this.pPosX;
    //this.pInitialPosY = this.pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    //this.pInitialWidth = pWidth;
    //this.pInitialHeight = pHeight;
    this.pImgSrc = pImgSrc;
    this.pScale = 1;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<img src="' + this.pImgSrc + '" class="backgroundImage">').appendTo(this.rPatent);
        makeUnselectable(this.rSelector);
        this.setScale(this.pScale);
    };

    /**
     * Setzt die SKalierung des Bildes
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        $(this.rSelector).css("width", this.pWidth * this.pScale + "px");
        $(this.rSelector).css("height", this.pHeight * this.pScale + "px");
        $(this.rSelector).css("left", this.pPosX * this.pScale + "px");
        $(this.rSelector).css("top", this.pPosY * this.pScale + "px");
        if (this.pBorderRadius != null) $(this.rSelector).css("border-radius", this.pBorderRadius * this.pScale + "px");
    };

    /**
     * Stellt den Grad der Eckabrundung ein
     * @param {float} pBorderRadius
     */
    this.setBorderRadius = function (pBorderRadius) {
        this.pBorderRadius = pBorderRadius;
    };

    /**
     * Exportiert den Zustand in einem JSON-Objekt
     */
    this.export = function () {};

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} rObj
     */
    this.import = function (rObj) {};
}
