/**
 * Klasse UncoverText
 * Bild mit Fragezeichenelementen, die durch Klciken einen Text anzeigen
 *
 * @constructor
 * @param {float} pPosX Position.x des Bildes
 * @param {float} pPosY Position-y des Bildes
 * @param {float} pWidth Breite des Bildes
 * @param {float} pHeight Höhe des Bildes
 * @param {float} pImgSrc Pfad des Bides
 */
function UncoverText(pPosX, pPosY, pWidth, pHeight, pImgSrc) {
    this.pType = "UncoverImage";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pImgSrc = pImgSrc;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.rCovers = [];
    this.pIndex = 0;
    this.pToggle = false;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<div class="uncoverText"></div>').appendTo(this.rPatent);
        makeUnselectable(this.rSelector);
        this.rImg = $('<img src="' + this.pImgSrc + '" class="wordGridImg">').appendTo(this.rSelector);
        this.rImg.css("z-index", 1);
        makeUnselectable(this.rImg);

        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        // individual solve button
        var btns = boards[this.pBoardId].addSolvabel(this);
        this.rSolve = btns.solve;
        this.rReset = btns.reset;
    };

    /**
     * Fuegt einen neuen Text hinzu
     * @param {float} pPosX Position.x des Elementes
     * @param {float} pPosY Position.y des Elementes
     * @param {float} pWidth Breite des Elementes
     * @param {float} pHeight Höhe des Elementes
     * @param {string} pText Text
     * @param {float} pFontSize Schriftgröße des Textes
     */
    this.addText = function (pPosX, pPosY, pWidth, pHeight, pText, pFontSize) {
        var t = this;
        var newCover = $('<div class="uncoverTextCover"></div>').appendTo(this.rSelector);
        newCover.css("z-index", 2);

        var newText = $('<div class="uncoverTextText"><span>' + pText + "</span></div>").appendTo(newCover);
        newText.attr("pInitialFont-size", pFontSize);
        newText.hide();
        var newQm = $('<div class="uncoverTextQm">?</div>').appendTo(newCover);
        newQm.click(function () {
            newText.show();
            newQm.hide();
        });
        // toggle functionality
        newText.click(function () {
            if (t.pToggle) {
                newQm.show();
                newText.hide();
            }
        });

        newCover.css("width", pWidth + "px");
        newCover.css("height", pHeight + "px");
        newCover.css("left", pPosX + "px");
        newCover.css("top", pPosY + "px");

        newCover.attr("pInitialWidth", pWidth);
        newCover.attr("pInitialHeight", pHeight);
        newCover.attr("pInitialLeft", pPosX);
        newCover.attr("pInitialTop", pPosY);

        this.rCovers.push(newCover);
    };

    /**
     * Stellt ein ob die Textelemente nach dem enthüllen wieder verhüllt werden können
     * @param {boolean} pToggle
     */
    this.setToggle = function (pToggle) {
        this.pToggle = pToggle;
    };

    /**
     * Setzt das Icon fuer den Solve-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setSolveIcon = function (pIcon) {
        this.rSolve.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt das Icon fuer den Reset-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setResetIcon = function (pIcon) {
        this.rReset.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        this.rSelector.find(".uncoverTextCover").each(function (i) {
            $(this).css("width", parseFloat($(this).attr("pInitialWidth")) * pScale + "px");
            $(this).css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");

            $(this)
                .find(".uncoverTextQm")
                .css("width", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this)
                .find(".uncoverTextQm")
                .css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this)
                .find(".uncoverTextQm")
                .css("font-size", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this)
                .find(".uncoverTextQm")
                .css("border-radius", parseFloat($(this).attr("pInitialHeight")) * pScale * 0.2 + "px");
            $(this)
                .find(".uncoverTextText")
                .css("font-size", parseFloat($(this).find(".uncoverTextText").attr("pInitialFont-size")) * pScale + "px");
            $(this)
                .find(".uncoverTextText")
                .css("border-radius", parseFloat($(this).attr("pInitialHeight")) * pScale * 0.2 + "px");
        });
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {
        for (let i = 0; i < this.rCovers.length; i++) {
            $(this.rCovers[i]).find(".uncoverTextQm").hide();
            $(this.rCovers[i]).find(".uncoverTextText").show();
        }
    };

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        for (let i = 0; i < this.rCovers.length; i++) {
            $(this.rCovers[i]).find(".uncoverTextQm").show();
            $(this.rCovers[i]).find(".uncoverTextText").hide();
        }
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
            pIndex: this.pIndex,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && this.pJsonId == rObj.pJsonId) {
            this.pIndex = rObj.pIndex;
            for (let i = 0; i < this.pIndex; i++) {
                $(this.rCovers[i]).hide();
            }
        }
    };
}
