/**
 * Klasse UncoverImage
 * Bild das durch Klicken nach und nach enthüllt wird
 *
 * @constructor
 * @param {float} pPosX
 * @param {float} pPosY
 * @param {float} pWidth
 * @param {float} pHeight
 * @param {float} pImgSrc
 */
function UncoverImage(pPosX, pPosY, pWidth, pHeight, pImgSrc) {
    this.pType = "UncoverImage";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pImgSrc = pImgSrc;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.rCovers = [];
    this.pIndex = 0;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;
        this.rSelector = $('<div class="wordGrid"></div>').appendTo(this.rPatent);
        makeUnselectable(this.rSelector);
        this.rImg = $('<img src="' + this.pImgSrc + '" class="wordGridImg">').appendTo(this.rSelector);
        this.rImg.css("z-index", 1);
        makeUnselectable(this.rImg);

        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        var t = this;

        $(this.rSelector).click(function (e) {
            t.click();
        });

        // individual solve button
        var btns = boards[this.pBoardId].addSolvabel(this);
        this.rSolve = btns.solve;
        this.rReset = btns.reset;
    };

    /**
     * Setzt das Icon fuer den Solve-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setSolveIcon = function (pIcon) {
        this.rSolve.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt das Icon fuer den Reset-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setResetIcon = function (pIcon) {
        this.rReset.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Fügt eine neue Überdeckung hinzu
     * @param {float} pPosX Position.x der Überdeckung
     * @param {float} pPosY Position-y der Überdeckung
     * @param {float} pWidth Breite der Überdeckung
     * @param {float} pHeight Höhe der Überdeckung
     */
    this.addCover = function (pPosX, pPosY, pWidth, pHeight) {
        var newCover = $('<div class="uncoverImageCover"></div>').appendTo(this.rSelector);
        newCover.css("z-index", 2);

        newCover.css("width", pWidth + "px");
        newCover.css("height", pHeight + "px");
        newCover.css("left", pPosX + "px");
        newCover.css("top", pPosY + "px");

        newCover.attr("pInitialWidth", pWidth);
        newCover.attr("pInitialHeight", pHeight);
        newCover.attr("pInitialLeft", pPosX);
        newCover.attr("pInitialTop", pPosY);

        this.rCovers.push(newCover);
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        this.rSelector.find(".uncoverImageCover").each(function (i) {
            $(this).css("width", parseFloat($(this).attr("pInitialWidth")) * pScale + "px");
            $(this).css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");
        });
    };

    /**
     * Funktion wenn das Bild angeklickt wird
     */
    this.click = function () {
        $(this.rCovers[this.pIndex]).hide();
        this.pIndex = Math.min(this.pIndex + 1, this.rCovers.length - 1);
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {
        for (let i = 0; i < this.rCovers.length; i++) {
            $(this.rCovers[i]).hide();
        }
    };

    /**
     * Gibt an pb der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        for (let i = 0; i < this.rCovers.length; i++) {
            $(this.rCovers[i]).show();
        }

        this.pIndex = 0;
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
            pIndex: this.pIndex,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && this.pJsonId == rObj.pJsonId) {
            this.pIndex = rObj.pIndex;
            for (let i = 0; i < this.pIndex; i++) {
                $(this.rCovers[i]).hide();
            }
        }
    };
}
