/**
 * Klasse ToggleElement
 * Ein-/Ausblendbares Bild
 *
 * @constructor
 * @param {float} pImgPosX Postion.x des Bildes
 * @param {float} pImgPosY Position.y des Bildes
 * @param {float} pImgWidth Breite des Bildes
 * @param {float} pImgHeight Höhe des Bildes
 * @param {string} pImgSrc Pfad des Bildes
 * @param {Box} rImgBox Box in der sich das Bild befindet
 * @param {float} btnPosX Position.x des Toggleknopfes
 * @param {float} btnPosY Position.y des Toggleknopfes
 * @param {float} btnWidth Breite des Toggleknopfes
 * @param {float} btnHeight Höhe des Toggleknopfes
 * @param {string} btnText1 Text zum einblenden
 * @param {string} btnText2 Text zum ausblenden
 * @param {string RGB(r,g,b)} pBtnColor Hintergrundfarbe des Toggleknopfes
 * @param {Box} rBtnBox Box in der sich der Toggleknopf befindet
 */
function ToggleElement(pImgPosX, pImgPosY, pImgWidth, pImgHeight, pImgSrc, rImgBox, btnPosX, btnPosY, btnWidth, btnHeight, btnText1, btnText2, pBtnColor, rBtnBox) {
    this.pType = "ToggleElement";
    this.pImgWidth = pImgWidth;
    this.pImgHeight = pImgHeight;
    this.pImgPosX = pImgPosX;
    this.pImgPosY = pImgPosY;
    this.btnWidth = btnWidth;
    this.btnHeight = btnHeight;
    this.btnPosX = btnPosX;
    this.btnPosY = btnPosY;
    this.btnText1 = btnText1;
    this.btnText2 = btnText2;
    this.pSolved = true;
    this.pImgSrc = pImgSrc;
    this.rImgBox = rImgBox;
    this.rBtnBox = rBtnBox;
    this.pBtnColor = pBtnColor;
    this.pJsonId = newJsonId;

    /**
     * Setzt die Position
     * @param {float} pPosX X-Position
     * @param {float} pPosY Y-Position
     */
    this.setPos = function (pPosX, pPosY) {
        this.pPosX = pPosX;
        this.pPosY = pPosY;
    };

    /**
     * Funktion wenn der Knopf geklickt wird
     */
    this.click = function () {
        if (this.pSolved) {
            $(this.rImg).hide();
            $(this.btn).empty();
            $(this.btn).append(this.btnText1);
        } else {
            $(this.rImg).show();
            $(this.btn).empty();
            $(this.btn).append(this.btnText2);
        }
        this.pSolved = !this.pSolved;
    };

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rPatent = rParent;

        this.rImg = $('<img src="' + this.pImgSrc + '" class="toggleElementImg">').appendTo(this.rImgBox.rSelector);

        this.btn = $('<div class="toggleElementBtn shadow">' + this.btnText1 + "</div>").appendTo(this.rBtnBox.rSelector);
        this.btn.css("background-color", this.pBtnColor);
        makeUnselectable(this.btn);

        var t = this;

        $(this.btn).click(function (e) {
            t.click();
        });

        this.click();
        this.setScale(this.pScale);
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        $(this.rImg).css("width", this.pImgWidth * this.pScale + "px");
        $(this.rImg).css("height", this.pImgHeight * this.pScale + "px");

        $(this.rImg).css("left", this.pImgPosX * this.pScale + "px");
        $(this.rImg).css("top", this.pImgPosY * this.pScale + "px");

        $(this.btn).css("width", this.btnWidth * this.pScale + "px");
        $(this.btn).css("height", this.btnHeight * this.pScale + "px");

        $(this.btn).css("left", this.btnPosX * this.pScale + "px");
        $(this.btn).css("top", this.btnPosY * this.pScale + "px");

        $(this.btn).css("font-size", this.btnHeight * this.pScale * 0.9 + "px");
        $(this.btn).css("border-radius", this.btnHeight * this.pScale * 0.2 + "px");
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {
        /*if(!this.pSolved) {
			this.click();
		}*/
    };

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        if (this.pSolved) {
            this.click();
        }
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (obj) {
        if (obj.pType == "ToggleElement") {
            if (this.isSolved() != obj.pSolved) {
                this.click();
            }
        }
    };
}
