/**
 * Element dass eine Liste anzeigt. Jedes Listenelement zeigt beim hover/klick ein bestimmtes Bild an
 *
 * @constructor
 * @param {float} pPosX Position.x des Bereiches, in dem Die Bilder angezeigt werden sollen
 * @param {float} pPosY Position.y des Bereiches, in dem Die Bilder angezeigt werden sollen
 * @param {float} pWidth Breite des Bereiches, in dem Die Bilder angezeigt werden sollen
 * @param {float} pHeight Höhe des Bereiches, in dem Die Bilder angezeigt werden sollen
 */
function ListImage(pPosX, pPosY, pWidth, pHeight) {
    this.pType = "ListImage";
    this.pPosX = pPosX;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.rImgs = [];
    this.pIndex = 0;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        var t = this;
        this.rParent = rParent;
        this.rSelector = $('<div class="listImage"></div>').appendTo(this.rParent);
        makeUnselectable(this.rSelector);
        this.rSelector.css("top", pPosY + "px");
        this.rSelector.css("left", pPosX + "px");
        this.rSelector.css("width", pWidth + "px");
        this.rSelector.css("height", pHeight + "px");

        this.setIndex(0);
    };

    /**
     * Setzt das Icon fuer den Solve-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setSolveIcon = function (pIcon) {
        this.rSolve.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Setzt das Icon fuer den Reset-Knopf
     * @param {String} pIcon Pfad zum Icon-Bild
     */
    this.setResetIcon = function (pIcon) {
        this.rReset.css("background-image", "url(" + pIcon + ")");
    };

    /**
     * Fügt der Liste einen neuen Eintrag hinzu
     * @param {float} pPosX Position.x des Bildes
     * @param {float} pPosY Position.y des Bildes
     * @param {float} pWidth Breite des Bildes
     * @param {float} pHeight Höhe des Bildes
     * @param {string} pImgSrc Pfad des Bildes
     * @param {string} pTitle Titel in der Liste
     * @param {float} pTitleX Position.x des Titels
     * @param {float} pTitleY Position.x des Titels
     * @param {float} pFontSize Schriftgröße des Titels
     */
    this.addImage = function (pPosX, pPosY, pWidth, pHeight, pImgSrc, pTitle, pTitleX, pTitleY, pFontSize) {
        var newImg = $('<img src="' + pImgSrc + '" class="listImageImg">').appendTo(this.rSelector);
        newImg.css("z-index", 2);

        newImg.css("width", pWidth + "px");
        newImg.css("height", pHeight + "px");
        newImg.css("left", pPosX + "px");
        newImg.css("top", pPosY + "px");

        newImg.attr("pInitialWidth", pWidth);
        newImg.attr("pInitialHeight", pHeight);
        newImg.attr("pInitialLeft", pPosX);
        newImg.attr("pInitialTop", pPosY);
        newImg.attr("pIndex", this.rImgs.length);

        this.rImgs.push(newImg);

        // text

        var newText = $('<span class="listImageText">' + pTitle + "</span>").appendTo(this.rSelector);
        $(newText).css("left", pTitleX);
        $(newText).css("top", pTitleY);
        $(newText).css("font-size", pFontSize);

        $(newText).attr("pInitialLeft", pTitleX);
        $(newText).attr("pInitialTop", pTitleY);
        $(newText).attr("pInitialFont-size", pFontSize);

        //trigger image swap
        var t = this;
        var index = this.rImgs.length - 1;
        $(newText).mouseover(function (e) {
            t.setIndex(index);
        });
        $(newText).click(function (e) {
            t.setIndex(index);
        });

        //hide all
        this.setIndex(0);
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * this.pScale;
        this.pPosY = this.pInitialPosY * this.pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;

        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");
        $(this.rSelector).css("left", this.pPosX + "px");
        $(this.rSelector).css("top", this.pPosY + "px");

        this.rSelector.find(".listImageImg").each(function (i) {
            $(this).css("width", parseFloat($(this).attr("pInitialWidth")) * pScale + "px");
            $(this).css("height", parseFloat($(this).attr("pInitialHeight")) * pScale + "px");
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");
        });

        // text

        this.rSelector.find(".listImageText").each(function (i) {
            $(this).css("top", parseFloat($(this).attr("pInitialTop")) * pScale + "px");
            $(this).css("left", parseFloat($(this).attr("pInitialLeft")) * pScale + "px");
            $(this).css("font-size", parseFloat($(this).attr("pInitialFont-size")) * pScale + "px");
        });

        // buttons

        if (this.pBtns) {
            $(this.rBtnLeft).css("width", $(this.rBtnLeft).attr("pInitialWidth") * pScale);
            $(this.rBtnLeft).css("height", $(this.rBtnLeft).attr("pInitialHeight") * pScale);
            $(this.rBtnLeft).css("left", $(this.rBtnLeft).attr("pInitialLeft") * pScale);
            $(this.rBtnLeft).css("top", $(this.rBtnLeft).attr("pInitialTop") * pScale);
            $(this.rBtnLeft).css("font-size", $(this.rBtnLeft).attr("pInitialHeight") * pScale);

            $(this.rBtnRight).css("width", $(this.rBtnRight).attr("pInitialWidth") * pScale);
            $(this.rBtnRight).css("height", $(this.rBtnRight).attr("pInitialHeight") * pScale);
            $(this.rBtnRight).css("left", $(this.rBtnRight).attr("pInitialLeft") * pScale);
            $(this.rBtnRight).css("top", $(this.rBtnRight).attr("pInitialTop") * pScale);
            $(this.rBtnRight).css("font-size", $(this.rBtnRight).attr("pInitialHeight") * pScale);
        }
    };

    /**
     * Legt fest welcher der Bilder sichtbar ist
     * @param {int} pIndex Bild index
     */
    this.setIndex = function (pIndex) {
        this.pIndex = pIndex;
        for (let i = 0; i < this.rImgs.length; i++) {
            this.rImgs[i].hide();
        }
        if (this.rImgs.length > 0) {
            this.rImgs[pIndex].show();
        }
    };

    /**
     * Setzt die Hintergrundfarbe
     * @param {string RGB(r,g,b)} pColor
     */
    this.setBackgroundColor = function (pColor) {
        this.rSelector.css("background-color", pColor);
    };

    /**
     * Setzt die dicke und Farbe der Umrandung
     * @param {float} pSize
     * @param {string RGB(r,g,b)} pColor
     */
    this.setBorder = function (pSize, pColor) {
        this.rSelector.css("border", pSize + "px solid " + pColor);
    };

    /**
     * Stellt ein ob Ecken abgerundet werden sollen
     * @param {boolean} pEnable
     */
    this.setRoundCorners = function (pEnable) {
        if (pEnable) {
            this.rSelector.css("border-radius", "5%");
        } else {
            this.rSelector.css("border-radius", "0%");
        }
    };

    /**
     * Stellt den Loesungszustand her
     */
    this.solve = function () {};

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        this.setIndex(0);
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
            pIndex: this.pIndex,
        };

        return obj;
    };

    /**
     * Importiert den Zustand aus einem JSON-Objekt
     * @param {JSON} obj
     */
    this.import = function (rObj) {
        if (rObj.pType == this.pType && this.pJsonId == rObj.pJsonId) {
            this.setIndex(rObj.pIndex);
        }
    };
}
