/**
 * Infoelement, das vom Tafelrand ein und ausgefahren werden kann
 *
 * @constructor
 * @param {float} pPosX
 * @param {Box} rTargetBox
 * @param {float} pPosY
 * @param {string} pText
 * @param {color} pColor
 * @param {float} pFontSize
 * @param {float} pWidth
 * @param {float} pHeight
 */
function InfoSlider(pPosX, rTargetBox, pPosY, pText, pColor, pFontSize, pWidth, pHeight) {
    this.pType = "InfoSlider";
    this.pPosX = pPosX;
    this.rTargetBox = rTargetBox;
    this.pPosY = pPosY;
    this.pInitialPosX = pPosX;
    this.pInitialPosY = pPosY;
    // this.pWidth = 200;
    // this.pHeight = 50;
    // this.pInitialWidth = this.pWidth;
    // this.pInitialHeight = this.pHeight;
    this.pText = pText;
    this.pJsonId = newJsonId();
    this.pSolved = false;
    this.pScale = 1;
    this.pColor = pColor;
    this.pFontSize = pFontSize;
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pFixedSize = false;
    this.pImgLeft = false;
    this.pImgRight = false;
    this.pAnimated = false;

    /**
     * Erstellt das Element
     * @param {jqueryelement} rParent
     */
    this.create = function (rParent) {
        this.rParent = rParent;
        // this.rSelector = $('<div class="infoSlider shadow"></div>').appendTo(this.rParent);
        this.rSelector = $('<div class="infoSlider shadow"></div>').appendTo("#body");
        $(this.rSelector).css("background-color", this.pColor);
        $(this.rSelector).addClass("globalElement");
        $(this.rSelector).attr("board_id", $(this.rParent).attr("id"));
        boards[this.pBoardId].forceResetBtn();

        this.rArrow = $('<div class="infoSliderArrow">⭠</div>').appendTo(this.rSelector);
        makeUnselectable(this.rArrow);

        this.rText = $('<div class="infoSliderText">' + pText + "</div>").appendTo(this.rSelector);
        makeUnselectable(this.rText);
        $(this.rText).hide();

        this.pInitialWidth = $(this.rSelector).css("width");
        this.pInitialHeight = $(this.rSelector).css("height");

        if (this.pWidth != null && this.pHeight != null && this.pFontSize != null) {
            this.pFixedSize = true;
        }

        if (this.pFixedSize) {
            this.pInitialWidth = pWidth;
            this.pInitialHeight = pHeight;
            $(this.rText).css("white-space", "normal");
        }

        var t = this;

        $(this.rSelector).click(function (e) {
            t.click();
        });

        this.setScale(1);
    };

    /**
     * Setzt die Skalierung
     * @param {float} pScale
     */
    this.setScale = function (pScale) {
        var visible = $(this.rText).is(":visible");
        if (!visible) {
            $(this.rText).show();
        }

        this.pScale = pScale;
        this.pPosX = this.pInitialPosX * pScale;
        this.pPosY = this.pInitialPosY * pScale;
        this.rSelector.css("width", parseFloat(this.rArrow.css("width")) + parseFloat(this.rText.css("width")) * 1.2 + "px");

        if (this.pFixedSize) {
            this.pHeight = this.pInitialHeight * pScale;
            $(this.rSelector).css("height", this.pHeight);
            this.pWidth = this.pInitialWidth * pScale;
            $(this.rSelector).css("width", this.pWidth * 1);
            $(this.rText).css("font-size", this.pFontSize * pScale);
        }

        if (!this.pSolved) {
            $(this.rSelector).css("left", parseFloat($(window).width()) - parseFloat(this.rArrow.css("width")) * 3);
            $(this.rSelector).css("top", this.pPosY + parseFloat($(this.rTargetBox.rSelector).offset().top) + "px");
        } else {
            $(this.rSelector).css("left", parseFloat($(this.rTargetBox.rSelector).offset().left) + this.pPosX);
            $(this.rSelector).css("top", this.pPosY + parseFloat($(this.rTargetBox.rSelector).offset().top) + "px");
        }

        // center vertically
        $(this.rText).css("top", (this.pHeight - parseFloat($(this.rText).css("height"))) / 2);
        $(this.rArrow).css("top", (this.pHeight - parseFloat($(this.rArrow).css("height"))) / 2);

        if (this.pImgLeft) {
            $(this.rImgLeft).css("left", parseFloat($(this.rImgLeft).attr("pInitialLeft")) * pScale);
            $(this.rImgLeft).css("top", parseFloat($(this.rImgLeft).attr("pInitialTop")) * pScale);
            $(this.rImgLeft).css("width", parseFloat($(this.rImgLeft).attr("pInitialWidth")) * pScale);
            $(this.rImgLeft).css("height", parseFloat($(this.rImgLeft).attr("pInitialHeight")) * pScale);
        }

        if (this.pImgRight) {
            $(this.rImgRight).css("left", parseFloat($(this.rImgRight).attr("pInitialLeft")) * pScale);
            $(this.rImgRight).css("top", parseFloat($(this.rImgRight).attr("pInitialTop")) * pScale);
            $(this.rImgRight).css("width", parseFloat($(this.rImgRight).attr("pInitialWidth")) * pScale);
            $(this.rImgRight).css("height", parseFloat($(this.rImgRight).attr("pInitialHeight")) * pScale);
        }

        // center text horizontally
        $(this.rText).css("left", (parseFloat($(this.rSelector).css("width")) - (parseFloat($(this.rArrow).css("left")) + parseFloat($(this.rArrow).css("width"))) - parseFloat($(this.rText).css("width"))) / 2 + parseFloat($(this.rArrow).css("left")) + parseFloat($(this.rArrow).css("width")));
        // console.log((parseFloat($(this.rSelector).css("width")) - parseFloat($(this.rArrow).css("left"))) / 2);

        if (!visible) {
            $(this.rText).hide();
        }
    };

    /**
     * Ersetzt den Pfeil der nach links zeigt mit einem Bild
     *
     * @param {float} pPosX Bildposition.x
     * @param {float} pPosY Bildposition.y
     * @param {float} pWidth Bildbreite
     * @param {float} pHeight Bildhöhe
     * @param {string} pImg Bild Pfad
     */
    this.setIconLeft = function (pPosX, pPosY, pWidth, pHeight, pImg) {
        var img = $('<img src="' + pImg + '" class="infoSliderImg">').appendTo(this.rSelector);
        makeUnselectable(this.rSelector);
        img.css("top", pPosY + "px");
        img.css("left", pPosX + "px");
        img.css("width", pWidth + "px");
        img.css("height", pHeight + "px");

        img.attr("pInitialWidth", pWidth);
        img.attr("pInitialHeight", pHeight);
        img.attr("pInitialLeft", pPosX);
        img.attr("pInitialTop", pPosY);

        this.rImgLeft = img;
        this.pImgLeft = true;
        $(this.rArrow).hide();
    };

    /**
     * Ersetzt den Pfeil der nach rechts zeigt mit einem Bild
     *
     * @param {float} pPosX Bildposition.x
     * @param {float} pPosY Bildposition.y
     * @param {float} pWidth Bildbreite
     * @param {float} pHeight Bildhöhe
     * @param {string} pImg Bild Pfad
     */
    this.setIconRight = function (pPosX, pPosY, pWidth, pHeight, pImg) {
        var img = $('<img src="' + pImg + '" class="infoSliderImg">').appendTo(this.rSelector);
        makeUnselectable(this.rSelector);
        img.css("top", pPosY + "px");
        img.css("left", pPosX + "px");
        img.css("width", pWidth + "px");
        img.css("height", pHeight + "px");

        img.attr("pInitialWidth", pWidth);
        img.attr("pInitialHeight", pHeight);
        img.attr("pInitialLeft", pPosX);
        img.attr("pInitialTop", pPosY);

        this.rImgRight = img;
        this.pImgRight = true;
        img.hide();
    };

    /**
     * Funktion wenn der Slider angeklickt wird
     */
    this.click = function () {
        // this.rSelector.css("width", parseFloat(this.rArrow.css("width")) + parseFloat(this.rText.css("width")) + "px");

        if (!this.pAnimated) {
            if (!this.pSolved) {
                if (this.pImgRight) {
                    $(this.rArrow).hide();
                    $(this.rImgRight).show();
                } else {
                    $(this.rArrow).show();
                    $(this.rArrow).html("⭢");
                }
                if (this.pImgLeft) {
                    $(this.rImgLeft).hide();
                }
                //$(this.rText).text(rText);
                var t = this;
                this.pAnimated = true;
                this.rSelector.animate(
                    {
                        left: parseFloat($(this.rTargetBox.rSelector).offset().left) + this.pPosX,
                    },
                    500,
                    function () {
                        //t.setScale(t.pScale);
                        t.pAnimated = false;
                    }
                );
                $(this.rText).show();
                this.setScale(this.pScale);
                this.setScale(this.pScale);
                this.setScale(this.pScale);
            } else {
                if (this.pImgLeft) {
                    $(this.rArrow).hide();
                    $(this.rImgLeft).show();
                } else {
                    $(this.rArrow).show();
                    $(this.rArrow).html("⭠");
                }
                if (this.pImgRight) {
                    $(this.rImgRight).hide();
                }
                //$(this.rText).text("");
                var t = this;
                this.pAnimated = true;
                this.rSelector.animate(
                    {
                        // left: parseFloat($("#body").css("width")) - parseFloat(this.rArrow.css("width")) * 0,
                        left: parseFloat($(window).width()) - parseFloat(t.rArrow.css("width")) * 3,
                    },
                    500,
                    function () {
                        $(t.rText).hide();
                        //t.setScale(t.pScale);
                        t.pAnimated = false;
                    }
                );
            }
            this.pSolved = !this.pSolved;
            //this.setScale(this.pScale);
        }
    };

    /**
     * Stellt den Lösungszustand her
     */
    this.solve = function () {};

    /**
     * Gibt an ob der Lösungszustand vorliegt
     * @returns {boolean}
     */
    this.isSolved = function () {
        return this.pSolved;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        if (this.pSolved) {
            this.click();
        }
    };

    /**
     * Speichert den Zustand in einem JSON-Objekt
     * @returns {JSON} Zustand
     */
    this.export = function () {
        var obj = {
            pJsonId: this.pJsonId,
            pType: this.pType,
            pSolved: this.pSolved,
        };

        return obj;
    };

    /**
     * Setzt den in einem JSON-Objekt gespeicherten Zustand um
     * @param {JSON} rObj
     */
    this.import = function (rObj) {
        if (rObj.pType == "InfoSlider") {
            if (this.isSolved() != rObj.pSolved) {
                this.click();
            }
        }
    };
}
