/**
 * Klasse Box
 * Dynamischer Teil der Bühne. Enthält die Objekte der Tafeln
 *
 * @constructor
 * @param pWidth {float} Breite
 * @param pHeight {float} Höhe
 * @param pBreaking {Bool} erzwinge einen Spalten-/Zeilenumbruch
 */
function Box(pWidth, pHeight, pBreaking) {
    this.pType = "Box";
    this.pWidth = pWidth;
    this.pHeight = pHeight;
    this.pInitialWidth = pWidth;
    this.pInitialHeight = pHeight;
    this.pBreaking = pBreaking;
    this.rObjects = [];
    this.pJsonId = newJsonId();

    /**
     * Fuegt der Box ein Objekt hinzu
     * @param {WhiteBoardObject (Assignment, BackgroundImage, ...)} obj neues Objekt
     */
    this.addObject = function (obj) {
        obj.pId = this.pId + "_" + this.rObjects.length;
        this.rObjects.push(obj);
        this.rObjects[this.rObjects.length - 1].pBoardId = this.pBoardId;
        this.rObjects[this.rObjects.length - 1].create(this.rSelector);
    };

    /**
     * Setzt die Skalierung der Box
     * @param {float} pScale Skalierung
     */
    this.setScale = function (pScale) {
        this.pScale = pScale;
        this.pWidth = this.pInitialWidth * this.pScale;
        this.pHeight = this.pInitialHeight * this.pScale;
        $(this.rSelector).css("width", this.pWidth + "px");
        $(this.rSelector).css("height", this.pHeight + "px");

        for (let i = 0; i < this.rObjects.length; i++) {
            this.rObjects[i].setScale(this.pScale);
        }

        // info panel scale
        if (activeBoard == this.pBoardId) {
            $("#info_panel").css("width", $("#info_panel").attr("initialWidth") * pScale);
            $("#info_panel").css("height", $("#info_panel").attr("initialHeight") * pScale);
        }
    };

    /**
     * Stellt den Lösungszustand her
     */
    this.solve = function () {
        for (let i = 0; i < this.rObjects.length; i++) {
            if (this.rObjects[i].solve != null) {
                this.rObjects[i].solve();
            }
        }
    };

    /**
     * Gibt an, ob der Lösungszustand erreicht ist
     * @returns {boolean} True falls alle Objekte der Box geloest sind. Sonst false
     */
    this.isSolved = function () {
        var s = true;
        for (let i = 0; i < this.rObjects.length; i++) {
            if (!this.rObjects[i].isSolved()) {
                s = false;
            }
        }
        return s;
    };

    /**
     * Stellt den Ausganszustand her
     */
    this.reset = function () {
        for (let i = 0; i < this.rObjects.length; i++) {
            if (this.rObjects[i].reset != null) {
                this.rObjects[i].reset();
            }
        }
    };

    /**
     * Speichet den Zustand der Box in einem JSON Objekt
     * @returns {JSON} Zustand der Box
     */
    this.export = function () {
        var box = {
            pJsonId: this.pJsonId,
            rObjects: [],
        };

        for (let i = 0; i < this.rObjects.length; i++) {
            box.rObjects.push(this.rObjects[i].export());
        }

        return box;
    };

    /**
     * Setzt den in einem JSON-Objekt gespeicherten Zustand um
     * @param {JSON} rObj Zustand
     */
    this.import = function (rObj) {
        for (let i = 0; i < rObj.rObjects.length; i++) {
            this.rObjects[i].import(rObj.rObjects[i]);
        }

        $(this.rCanvas).appendTo(this.rDiv);
    };
}
